package com.maddox.il2.objects.air;

import com.maddox.il2.ai.*;
import com.maddox.il2.engine.*;
import com.maddox.il2.fm.*;

import com.maddox.JGP.Point3d;
import com.maddox.il2.ai.*;
import com.maddox.il2.engine.Config;
import com.maddox.il2.engine.HierMesh;
import com.maddox.il2.fm.*;
import com.maddox.il2.game.Main3D;
import com.maddox.rts.Property;

import com.maddox.JGP.Point3d;
import com.maddox.JGP.Tuple3d;
import com.maddox.il2.ai.*;
import com.maddox.il2.engine.*;
import com.maddox.il2.fm.*;
import com.maddox.il2.game.HUD;
import com.maddox.il2.game.Main3D;
import com.maddox.rts.Property;

public class LAGG_3RD extends Scheme1
    implements TypeFighter
{

    public LAGG_3RD()
    {
        kl = 1.0F;
        kr = 1.0F;
        kc = 1.0F;
        headPos = new float[3];
        headOr = new float[3];
        oldctl = -1F;
        curctl = -1F;
    }

    public void hitDaSilk()
    {
        super.hitDaSilk();
        if(!sideDoorOpened && FM.AS.bIsAboutToBailout && !FM.AS.isPilotDead(0))
        {
            sideDoorOpened = true;
            FM.CT.bHasCockpitDoorControl = true;
            FM.CT.forceCockpitDoor(0.0F);
            FM.AS.setCockpitDoor(this, 1);
        }
    }

    public void movePilotsHead(float f, float f1)
    {
        if(Config.isUSE_RENDER() && (headTp < f1 || headTm > f1 || headYp < f || headYm > f))
        {
            headTp = f1 + 0.0005F;
            headTm = f1 - 0.0005F;
            headYp = f + 0.0005F;
            headYm = f - 0.0005F;
            f *= 0.7F;
            f1 *= 0.7F;
            tmpOrLH.setYPR(0.0F, 0.0F, 0.0F);
            tmpOrLH.increment(0.0F, f, 0.0F);
            tmpOrLH.increment(f1, 0.0F, 0.0F);
            tmpOrLH.increment(0.0F, 0.0F, -0.2F * f1 + 0.05F * f);
            headOr[0] = tmpOrLH.getYaw();
            headOr[1] = tmpOrLH.getPitch();
            headOr[2] = tmpOrLH.getRoll();
            headPos[0] = 0.0001F * Math.abs(f);
            headPos[1] = -0.0001F * Math.abs(f);
            headPos[2] = 0.0F;
            hierMesh().chunkSetLocate("Head1_D0", headPos, headOr);
        }
    }

    public void moveSteering(float f)
    {
        hierMesh().chunkSetAngles("GearC2_D0", 0.0F, f, 0.0F);
    }

    protected void moveAileron(float f)
    {
        if(f < 0.0F)
        {
            hierMesh().chunkSetAngles("AroneL_D0", 0.0F, -18F * f, 0.0F);
            hierMesh().chunkSetAngles("AroneR_D0", 0.0F, -18F * f, 0.0F);
        } else
        {
            hierMesh().chunkSetAngles("AroneL_D0", 0.0F, -18F * f, 0.0F);
            hierMesh().chunkSetAngles("AroneR_D0", 0.0F, -18F * f, 0.0F);
        }
    }

    protected void moveRudder(float f)
    {
        hierMesh().chunkSetAngles("Rudder1_D0", 0.0F, -25F * f, 0.0F);
    }

    protected void moveElevator(float f)
    {
        if(f < 0.0F)
        {
            hierMesh().chunkSetAngles("VatorL_D0", 0.0F, -16.5F * f, 0.0F);
            hierMesh().chunkSetAngles("VatorR_D0", 0.0F, -16.5F * f, 0.0F);
        } else
        {
            hierMesh().chunkSetAngles("VatorL_D0", 0.0F, -16.5F * f, 0.0F);
            hierMesh().chunkSetAngles("VatorR_D0", 0.0F, -16.5F * f, 0.0F);
        }
    }

    protected void moveFlap(float paramFloat)
    {
        float f = -60F * paramFloat;
        hierMesh().chunkSetAngles("Flap01_D0", 0.0F, f, 0.0F);
        hierMesh().chunkSetAngles("Flap02_D0", 0.0F, f, 0.0F);
        hierMesh().chunkSetAngles("Flap03_D0", 0.0F, f, 0.0F);
        hierMesh().chunkSetAngles("Flap04_D0", 0.0F, f, 0.0F);
    }

    public float getEyeLevelCorrection()
    {
        return 0.1F;
    }

    public void moveCockpitDoor(float f)
    {
        resetYPRmodifier();
        Aircraft.xyz[1] = Aircraft.cvt(f, 0.01F, 0.99F, 0.0F, 0.58F);
        hierMesh().chunkSetLocate("Blister1_D0", Aircraft.xyz, Aircraft.ypr);
        float f1 = (float)Math.sin(Aircraft.cvt(f, 0.01F, 0.99F, 0.0F, 3.141593F));
        hierMesh().chunkSetAngles("Head1_D0", 12F * f1, 0.0F, 0.0F);
        if(Config.isUSE_RENDER())
        {
            if(Main3D.cur3D().cockpits != null && Main3D.cur3D().cockpits[0] != null)
                Main3D.cur3D().cockpits[0].onDoorMoved(f);
            setDoorSnd(f);
        }
    }

    public void onAircraftLoaded()
    {
        super.onAircraftLoaded();
        ((FlightModelMain) (super.FM)).CT.bHasCockpitDoorControl = true;
        ((FlightModelMain) (super.FM)).CT.dvCockpitDoor = 0.75F;
    }

    public void update(float f)
    {
        if(FM.AS.isMaster())
            if(curctl == -1F)
            {
                curctl = oldctl = FM.EI.engines[0].getControlThrottle();
            } else
            {
                curctl = FM.EI.engines[0].getControlThrottle();
                if((curctl - oldctl) / f > 3F && FM.EI.engines[0].getRPM() < 2100F && FM.EI.engines[0].getStage() == 6 && World.Rnd().nextFloat() < 0.25F)
                    FM.AS.hitEngine(this, 0, 100);
                if((curctl - oldctl) / f < -3F && FM.EI.engines[0].getRPM() < 2100F && FM.EI.engines[0].getStage() == 6)
                {
                    if(World.Rnd().nextFloat() < 0.25F && (FM instanceof RealFlightModel) && ((RealFlightModel)FM).isRealMode())
                        FM.EI.engines[0].setEngineStops(this);
                    if(World.Rnd().nextFloat() < 0.75F && (FM instanceof RealFlightModel) && ((RealFlightModel)FM).isRealMode())
                        FM.EI.engines[0].setKillCompressor(this);
                }
                oldctl = curctl;
            }
        if(Config.isUSE_RENDER() && FM.AS.isMaster())
            if(FM.EI.engines[0].getPowerOutput() > 0.8F && FM.EI.engines[0].getStage() == 6)
            {
                if(FM.EI.engines[0].getPowerOutput() > 0.95F)
                    FM.AS.setSootState(this, 0, 3);
                else
                    FM.AS.setSootState(this, 0, 2);
            } else
            {
                FM.AS.setSootState(this, 0, 0);
            }
        if(FM.getSpeed() > 5F)
        {
            hierMesh().chunkSetAngles("SlatL_D0", 0.0F, Aircraft.cvt(FM.getAOA(), 6.8F, 11F, 0.0F, 1.2F), 0.0F);
            hierMesh().chunkSetAngles("SlatR_D0", 0.0F, Aircraft.cvt(FM.getAOA(), 6.8F, 11F, 0.0F, 1.2F), 0.0F);
        }
        super.update(f);
    }

    public void doMurderPilot(int i)
    {
        switch(i)
        {
        case 0: // '\0'
            hierMesh().chunkVisible("Pilot1_D0", false);
            hierMesh().chunkVisible("Head1_D0", false);
            hierMesh().chunkVisible("HMask1_D0", false);
            hierMesh().chunkVisible("Pilot1_D1", true);
            break;
        }
    }

    public static void moveGear(HierMesh hiermesh, float f, float f1, float f2)
    {
        hiermesh.chunkSetAngles("GearL2_D0", 0.0F, 80F * f * kl, 0.0F);
        hiermesh.chunkSetAngles("GearR2_D0", 0.0F, -80F * f1 * kr, 0.0F);
        hiermesh.chunkSetAngles("GearL3_D0", 0.0F, 100F * f * kl, 0.0F);
        hiermesh.chunkSetAngles("GearR3_D0", 0.0F, 100F * f1 * kr, 0.0F);
        hiermesh.chunkSetAngles("GearC99_D0", 0.0F, -75F * f2 * kc, 0.0F);
        float f3 = Math.max(-f2 * 1200F, -80F);
        hiermesh.chunkSetAngles("GearC3_D0", 0.0F, -f3 * kc, 0.0F);
        hiermesh.chunkSetAngles("GearC4_D0", 0.0F, -f3 * kc, 0.0F);
        Aircraft.xyz[0] = Aircraft.xyz[1] = Aircraft.xyz[2] = 0.0F;
        Aircraft.ypr[0] = Aircraft.ypr[1] = Aircraft.ypr[2] = 0.0F;
        Aircraft.xyz[2] = Aircraft.cvt(f, 0.0F, 1.0F, 0.0F, 0.1F);
        hiermesh.chunkSetLocate("poleL_D0", Aircraft.xyz, Aircraft.ypr);
        hiermesh.chunkSetLocate("poleR_D0", Aircraft.xyz, Aircraft.ypr);
    }

    protected void moveGear(float f, float f1, float f2)
    {
        moveGear(hierMesh(), f, f1, f2);
        if(((FlightModelMain) (super.FM)).CT.getGear() >= 0.997F)
        {
            kl = 1.0F;
            kr = 1.0F;
            kc = 1.0F;
		}
    }

    protected void hitBone(String s, Shot shot, Point3d point3d)
    {
        if(s.startsWith("xblister1") && World.Rnd().nextFloat() < 0.05F && ((FlightModelMain) (super.FM)).CT.bHasCockpitDoorControl)
        {
            ((FlightModelMain) (super.FM)).CT.bHasCockpitDoorControl = false;
            if(((FlightModelMain) (super.FM)).CT.cockpitDoorControl == 0.0F)
            {
                if(((FlightModelMain) (super.FM)).AS.bIsEnableToBailout)
                    ((FlightModelMain) (super.FM)).AS.bIsEnableToBailout = false;
                if(super.FM.isPlayers())
                    HUD.log("\u041A\u0440\u044B\u0448\u043A\u0443 \u0444\u043E\u043D\u0430\u0440\u044F \u0437\u0430\u043A\u043B\u0438\u043D\u0438\u043B\u043E, \u0432\u044B\u043F\u0440\u044B\u0433\u043D\u0443\u0442\u044C \u043D\u0435\u0432\u043E\u0437\u043C\u043E\u0436\u043D\u043E");
/*                     HUD.log("canopy jammed... bail out not available"); */
            }
        }
        if(s.startsWith("xx"))
        {
            if(s.startsWith("xxarmor"))
            {
                if(s.endsWith("p1"))
                    getEnergyPastArmor(8.5F, shot);
                else
                if(s.endsWith("g1"))
                {
                    ((FlightModelMain) (super.FM)).AS.setCockpitState(shot.initiator, ((FlightModelMain) (super.FM)).AS.astateCockpitState | 2);
                    getEnergyPastArmor(18.15F / (1E-005F + (float)Math.abs(((Tuple3d) (Aircraft.v1)).x)), shot);
                } return;
            }
            if(s.startsWith("xxcontrols"))
            {
                debuggunnery("Controls: Hit..");
                int i = s.charAt(10) - 48;
                switch(i)
                {
                default:
                    break;

                case 1: //Тросы управления двигателем
                    if(getEnergyPastArmor(0.1F, shot) > 0.0F)
                    {
                        if(World.Rnd().nextFloat() < 0.1F)
                            FM.AS.setEngineSpecificDamage(shot.initiator, 0, 1);
                        if(World.Rnd().nextFloat() < 0.1F)
                            FM.AS.setEngineSpecificDamage(shot.initiator, 0, 6);
                    }
                    break;

                case 2: //РУС
                    if(getEnergyPastArmor(3.2F, shot) > 0.0F)
                    {
                        Aircraft.debugprintln(this, "*** Control Column: Hit, Controls Destroyed..");
                        FM.AS.setControlsDamage(shot.initiator, 1);
                        FM.AS.setControlsDamage(shot.initiator, 0);
                    }
                    break;

                case 3: //Левая длинная тяга
                case 4: //Правая длинная тяга
                case 9: //Левая короткая тяга
                case 10: //Правая короткая тяга
                    if(getEnergyPastArmor(2.0F, shot) > 0.0F && World.Rnd().nextFloat() < 0.25F)
                    {
                        debuggunnery("Controls: Ailerones Controls: Out..");
                        FM.AS.setControlsDamage(shot.initiator, 0);
                    }
                    break;

                case 5: //Трос РН
                    if(getEnergyPastArmor(0.75F, shot) > 0.0F && World.Rnd().nextFloat() < 0.25F)
                    {
                        debuggunnery("Controls: Rudder Controls: Disabled / Strings Broken..");
                        FM.AS.setControlsDamage(shot.initiator, 2);
                    }
                    break;

                case 6: //Педали РН
                    if(getEnergyPastArmor(1.75F, shot) > 0.0F && World.Rnd().nextFloat() < 0.25F)
                    {
                        debuggunnery("Controls: Rudder Controls: Disabled / Strings Broken..");
                        FM.AS.setControlsDamage(shot.initiator, 2);
                    }
                    break;

                case 7: //Тяги РН
                    if(getEnergyPastArmor(1.75F, shot) > 0.0F && World.Rnd().nextFloat() < 0.25F)
                    {
                        debuggunnery("Controls: Elevator Controls: Disabled..");
                        FM.AS.setControlsDamage(shot.initiator, 1);
                    }
                    break;

                case 8: //РУД
                    if(getEnergyPastArmor(2.0F, shot) > 0.0F && World.Rnd().nextFloat() < 0.25F)
                    {
                        FM.AS.setEngineSpecificDamage(shot.initiator, 0, 1);
                        FM.AS.setEngineSpecificDamage(shot.initiator, 0, 6);
                        Aircraft.debugprintln(this, "*** Throttle Quadrant: Hit, Engine Controls Disabled..");
                    }
                    break;
                }
                return;
            }
            if(s.startsWith("xxeng1"))
            {
                if(point3d.x > 1.054D && point3d.x < 1.417D)
                    FM.EI.engines[0].setCyliderKnockOut(shot.initiator, World.Rnd().nextInt(1, 6));
                if(World.Rnd().nextFloat(0.009F, 0.1357F) < shot.mass)
                    FM.AS.hitEngine(shot.initiator, 0, 2);
                getEnergyPastArmor(14.296F, shot);
                return;
            }
            if(s.startsWith("xxlock"))
            {
                if(s.endsWith("al"))
                {
                    if(getEnergyPastArmor(0.35F, shot) > 0.0F)
                    {
                        Aircraft.debugprintln(this, "*** AroneL Lock Damaged..");
                        nextDMGLevels(1, 2, "AroneL_D0", shot.initiator);
                    }
                } else
                if(s.endsWith("ar"))
                {
                    if(getEnergyPastArmor(0.35F, shot) > 0.0F)
                    {
                        Aircraft.debugprintln(this, "*** AroneR Lock Damaged..");
                        nextDMGLevels(1, 2, "AroneR_D0", shot.initiator);
                    }
                } else
                if(s.endsWith("vl1") || s.endsWith("vl2"))
                {
                    if(getEnergyPastArmor(0.35F, shot) > 0.0F)
                    {
                        Aircraft.debugprintln(this, "*** VatorL Lock Damaged..");
                        nextDMGLevels(1, 2, "VatorL_D0", shot.initiator);
                    }
                } else
                if(s.endsWith("vr1") || s.endsWith("vr2"))
                {
                    if(getEnergyPastArmor(0.35F, shot) > 0.0F)
                    {
                        Aircraft.debugprintln(this, "*** VatorR Lock Damaged..");
                        nextDMGLevels(1, 2, "VatorR_D0", shot.initiator);
                    }
                } else
                if((s.endsWith("r1") || s.endsWith("r2")) && getEnergyPastArmor(0.35F, shot) > 0.0F)
                {
                    Aircraft.debugprintln(this, "*** Rudder1 Lock Damaged..");
                    nextDMGLevels(1, 2, "Rudder1_D0", shot.initiator);
                }
                return;
            }
            if(s.startsWith("xxshvak"))
            {
                int j = s.charAt(7) - 49;
														 
				 
																				 
                FM.AS.setJamBullets(1, j);
                getEnergyPastArmor(12F, shot);
				 
                return;
            }
            if(s.startsWith("xxammo"))
            {
                if(getEnergyPastArmor(4.81F, shot) > 0.0F)
                {
                    if(World.Rnd().nextFloat() < 0.12F)
                        FM.AS.setJamBullets(1, 0);
                    if(World.Rnd().nextFloat() < 0.12F)
                        FM.AS.setJamBullets(1, 1);
                    if(World.Rnd().nextFloat() < 0.012F)
                        FM.AS.explodeTank(shot.initiator, 0);
                    getEnergyPastArmor(8.98F, shot);
                }
                return;
            }
            if(s.startsWith("xxoil"))
            {
																			   
																					  
																				
																							   
																				
																								 
																				
																								 
																				
																								   
			 
										 
			 
                if(getEnergyPastArmor(0.25F, shot) > 0.0F && World.Rnd().nextFloat() < 0.125F)
                {
                    ((FlightModelMain) (super.FM)).AS.hitOil(shot.initiator, 0);
                    getEnergyPastArmor(0.22F, shot);
                    debuggunnery("Engine Module: Oil Tank Pierced..");
					if(super.FM.isPlayers())
					HUD.log("\u041C\u0430\u0441\u043B\u043E\u0431\u0430\u043A \u043F\u0440\u043E\u0431\u0438\u0442");
                }
                return;
            }
									 
			 
																							 
				 
													
													
																		  
							  
																																	 
				 
					   
			 
            if(s.startsWith("xxtank"))
            {
                int k = s.charAt(6) - 49;
                if(getEnergyPastArmor(1.5F, shot) > 0.0F && World.Rnd().nextFloat() < 0.5F)
                {
                    if(FM.AS.astateTankStates[k] == 0)
                    {
                        debuggunnery("Fuel Tank (" + k + "): Pierced..");
                        FM.AS.hitTank(shot.initiator, k, 1);
                        FM.AS.doSetTankState(shot.initiator, k, 1);
                    }else
                    if(FM.AS.astateTankStates[k] == 1)
                    {
                        debuggunnery("Fuel Tank (" + k + "): Pierced..");
                        FM.AS.hitTank(shot.initiator, k, 2);
                        FM.AS.doSetTankState(shot.initiator, k, 2);  
                    }
                    if(World.Rnd().nextFloat() < 0.01F || shot.powerType == 3 && World.Rnd().nextFloat() < 0.8F)
                    {
                        debuggunnery("Fuel Tank (" + k + "): Hit..");
                        FM.AS.doSetTankState(shot.initiator, k, 5); 
                    }
                }
                return;
            }
            if(s.startsWith("xxpneu") && getEnergyPastArmor(4.8F, shot) > 0.0F)//пробитие баллона пневмосистемы
            {
				((FlightModelMain) (super.FM)).CT.bHasBrakeControl = false;//отказ тормозов
				if(super.FM.isPlayers())
				HUD.log("\u041F\u043D\u0435\u0432\u043C\u043E\u0441\u0438\u0441\u0442\u0435\u043C\u0430 \u043F\u043E\u0432\u0440\u0435\u0436\u0434\u0435\u043D\u0430");
				return;
            }
            if(s.startsWith("xxhyd") && getEnergyPastArmor(4.8F, shot) > 0.0F)//пробитие бачка гидросистемы
            {
                FM.AS.setInternalDamage(shot.initiator, 0);//выпуск шасси невозможен
                FM.AS.setInternalDamage(shot.initiator, 1);//выпуск щитков невозможен
				if(super.FM.isPlayers())
				HUD.log("\u0413\u0438\u0434\u0440\u043E\u0441\u0438\u0441\u0442\u0435\u043C\u0430 \u043F\u043E\u0432\u0440\u0435\u0436\u0434\u0435\u043D\u0430");
				return;
            }
            if(s.startsWith("xxspar"))
            {
                if((s.endsWith("li1") || s.endsWith("li2")) && (double)World.Rnd().nextFloat() < 1.0D - 0.92000001668930054D * Math.abs(((Tuple3d) (Aircraft.v1)).x) && chunkDamageVisible("WingLIn") > 2 && getEnergyPastArmor(2.5F * World.Rnd().nextFloat(1.0F, 1.2F), shot) > 0.0F)
                {
                    Aircraft.debugprintln(this, "*** WingLIn Spars Damaged..");
                    nextDMGLevels(1, 2, "WingLIn_D3", shot.initiator);
                }
                if((s.endsWith("ri1") || s.endsWith("ri2")) && (double)World.Rnd().nextFloat() < 1.0D - 0.92000001668930054D * Math.abs(((Tuple3d) (Aircraft.v1)).x) && chunkDamageVisible("WingRIn") > 2 && getEnergyPastArmor(2.5F * World.Rnd().nextFloat(1.0F, 1.2F), shot) > 0.0F)
                {
                    Aircraft.debugprintln(this, "*** WingRIn Spars Damaged..");
                    nextDMGLevels(1, 2, "WingRIn_D3", shot.initiator);
                }
                if((s.endsWith("lm1") || s.endsWith("lm2")) && (double)World.Rnd().nextFloat() < 1.0D - 0.92000001668930054D * Math.abs(((Tuple3d) (Aircraft.v1)).x) && chunkDamageVisible("WingLMid") > 2 && getEnergyPastArmor(2.5F * World.Rnd().nextFloat(1.0F, 1.2F), shot) > 0.0F)
                {
                    Aircraft.debugprintln(this, "*** WingLMid Spars Damaged..");
                    nextDMGLevels(1, 2, "WingLMid_D3", shot.initiator);
                }
                if((s.endsWith("rm1") || s.endsWith("rm2")) && (double)World.Rnd().nextFloat() < 1.0D - 0.92000001668930054D * Math.abs(((Tuple3d) (Aircraft.v1)).x) && chunkDamageVisible("WingRMid") > 2 && getEnergyPastArmor(2.5F * World.Rnd().nextFloat(1.0F, 1.2F), shot) > 0.0F)
                {
                    Aircraft.debugprintln(this, "*** WingRMid Spars Damaged..");
                    nextDMGLevels(1, 2, "WingRMid_D3", shot.initiator);
                }
                if((s.endsWith("lo1") || s.endsWith("lo2")) && (double)World.Rnd().nextFloat() < 1.0D - 0.92000001668930054D * Math.abs(((Tuple3d) (Aircraft.v1)).x) && chunkDamageVisible("WingLOut") > 2 && getEnergyPastArmor(1.5F * World.Rnd().nextFloat(1.0F, 1.2F), shot) > 0.0F)
                {
                    Aircraft.debugprintln(this, "*** WingLOut Spars Damaged..");
                    nextDMGLevels(1, 2, "WingLOut_D3", shot.initiator);
                }
                if((s.endsWith("ro1") || s.endsWith("ro2")) && (double)World.Rnd().nextFloat() < 1.0D - 0.92000001668930054D * Math.abs(((Tuple3d) (Aircraft.v1)).x) && chunkDamageVisible("WingROut") > 2 && getEnergyPastArmor(1.5F * World.Rnd().nextFloat(1.0F, 1.2F), shot) > 0.0F)
                {
                    Aircraft.debugprintln(this, "*** WingROut Spars Damaged..");
                    nextDMGLevels(1, 2, "WingROut_D3", shot.initiator);
                }
                if((s.endsWith("sl1") || s.endsWith("sl2")) && chunkDamageVisible("StabL") > 2 && getEnergyPastArmor(3.5F * World.Rnd().nextFloat(1.0F, 1.2F), shot) > 0.0F)
                {
                    Aircraft.debugprintln(this, "*** StabL Spars Damaged..");
                    nextDMGLevels(1, 2, "StabL_D3", shot.initiator);
                }
                if((s.endsWith("sr1") || s.endsWith("sr2")) && chunkDamageVisible("StabR") > 2 && getEnergyPastArmor(3.5F * World.Rnd().nextFloat(1.0F, 1.2F), shot) > 0.0F)
                {
                    Aircraft.debugprintln(this, "*** StabR Spars Damaged..");
                    nextDMGLevels(1, 2, "StabR_D3", shot.initiator);
                }
				if(s.startsWith("xxspark") && World.Rnd().nextFloat() < 0.5F && getEnergyPastArmor((double)(6.8F * World.Rnd().nextFloat(1.0F, 1.5F)) / (Math.abs(Aircraft.v1.x) + 9.9999997473787516E-005D), shot) > 0.0F)
                {
                    Aircraft.debugprintln(this, "*** Keel Spars Damaged..");
                    nextDMGLevels(1, 2, "Keel1_D" + chunkDamageVisible("Keel1"), shot.initiator);
                }
                if(s.startsWith("xxspart") && chunkDamageVisible("Tail1") > 2 && getEnergyPastArmor(3.86F / (float)Math.sqrt(Aircraft.v1.y * Aircraft.v1.y + Aircraft.v1.z * Aircraft.v1.z), shot) > 0.0F && World.Rnd().nextFloat() < 0.25F)
                {
                    debuggunnery("Spar Construction: Tail1 Ribs Hit, Breaking in Half..");
                    nextDMGLevels(1, 2, "Tail1_D3", shot.initiator);
                }
                return;
            }
            if(s.startsWith("xxins"))
                FM.AS.setCockpitState(shot.initiator, FM.AS.astateCockpitState | 0x40);
            return;
        }
        if(s.startsWith("xcf") || s.startsWith("xcockpit"))
        {
            if(chunkDamageVisible("CF") < 3)
				hitChunk("CF", shot);
            if(s.startsWith("xcockpit"))
            {
                if(point3d.z > 0.7160000205039978D && World.Rnd().nextFloat() < 0.25F && World.Rnd().nextFloat() < 0.2F)
                    FM.AS.setCockpitState(shot.initiator, FM.AS.astateCockpitState | 1);
                if(point3d.z > 0.7160000205039978D && World.Rnd().nextFloat() < 0.25F && World.Rnd().nextFloat() < 0.2F)
                    FM.AS.setCockpitState(shot.initiator, FM.AS.astateCockpitState | 8);
                if(point3d.x > -0.5D && World.Rnd().nextFloat() < 0.2F)
                    FM.AS.setCockpitState(shot.initiator, FM.AS.astateCockpitState | 0x20);
            }
            return;
        } else
        if(s.startsWith("xeng"))
        {
            if(chunkDamageVisible("Engine1") < 2)
                hitChunk("Engine1", shot);
        } else
        if(s.startsWith("xtail"))
        {
            if(chunkDamageVisible("Tail1") < 3)
                hitChunk("Tail1", shot);
        } else
        if(s.startsWith("xkeel"))
        {
            if(chunkDamageVisible("Keel1") < 2)
                hitChunk("Keel1", shot);
        } else
        if(s.startsWith("xrudder"))
        {
            if(chunkDamageVisible("Rudder1") < 1)
                hitChunk("Rudder1", shot);
        } else
        if(s.startsWith("xstab"))
        {
            if(s.startsWith("xstabl") && chunkDamageVisible("StabL") < 2)
                hitChunk("StabL", shot);
            if(s.startsWith("xstabr") && chunkDamageVisible("StabR") < 2)
                hitChunk("StabR", shot);
        } else
        if(s.startsWith("xvator"))
        {
            if(s.startsWith("xvatorl") && chunkDamageVisible("VatorL") < 1)
                hitChunk("VatorL", shot);
            if(s.startsWith("xvatorr") && chunkDamageVisible("VatorR") < 1)
                hitChunk("VatorR", shot);
        } else
        if(s.startsWith("xwing"))
        {
            if(s.startsWith("xwinglin") && chunkDamageVisible("WingLIn") < 3)
                hitChunk("WingLIn", shot);
            if(s.startsWith("xwingrin") && chunkDamageVisible("WingRIn") < 3)
                hitChunk("WingRIn", shot);
            if(s.startsWith("xwinglmid") && chunkDamageVisible("WingLMid") < 3)
                hitChunk("WingLMid", shot);
            if(s.startsWith("xwingrmid") && chunkDamageVisible("WingRMid") < 3)
                hitChunk("WingRMid", shot);
            if(s.startsWith("xwinglout") && chunkDamageVisible("WingLOut") < 3)
                hitChunk("WingLOut", shot);
            if(s.startsWith("xwingrout") && chunkDamageVisible("WingROut") < 3)
                hitChunk("WingROut", shot);
        } else
        if(s.startsWith("xarone"))
        {
            if(s.startsWith("xaronel") && chunkDamageVisible("AroneL") < 1)
                hitChunk("AroneL", shot);
            if(s.startsWith("xaroner") && chunkDamageVisible("AroneR") < 1)
                hitChunk("AroneR", shot);
        } else
        if(s.startsWith("xgear"))
        {
            if(s.endsWith("1") && World.Rnd().nextFloat() < 0.05F)
            {
                debuggunnery("Hydro System: Disabled..");
				if(super.FM.isPlayers())
				HUD.log("\u0413\u0438\u0434\u0440\u043E\u0441\u0438\u0441\u0442\u0435\u043C\u0430 \u043D\u0435\u0438\u0441\u043F\u0440\u0430\u0432\u043D\u0430");
                gearDamageFX(s);
                FM.AS.setInternalDamage(shot.initiator, 0);
            }
            if(s.endsWith("2") && World.Rnd().nextFloat() < 0.1F && getEnergyPastArmor(World.Rnd().nextFloat(1.2F, 3.435F), shot) > 0.0F)
            {
                debuggunnery("Undercarriage: Stuck..");
				if(super.FM.isPlayers())
				HUD.log("\u0428\u0430\u0441\u0441\u0438 \u0437\u0430\u043A\u043B\u0438\u043D\u0438\u043B\u043E");
                FM.AS.setInternalDamage(shot.initiator, 3);
            }
        } else
        if(s.startsWith("xpilot") || s.startsWith("xhead"))
        {
            byte byte0 = 0;
            int l;
            if(s.endsWith("a"))
            {
                byte0 = 1;
                l = s.charAt(6) - 49;
            } else
            if(s.endsWith("b"))
            {
                byte0 = 2;
                l = s.charAt(6) - 49;
            } else
            {
                l = s.charAt(5) - 49;
            }
            hitFlesh(l, shot, byte0);
        }
    }

    private void gearDamageFX(String s)
    {
        if(s.startsWith("xgearl") || s.startsWith("GearL"))
        {
            if(super.FM.isPlayers())
            HUD.log("\u041B\u0435\u0432\u0430\u044F \u0441\u0442\u043E\u0439\u043A\u0430 \u0448\u0430\u0441\u0441\u0438: \u043E\u0442\u043A\u0430\u0437 \u0433\u0438\u0434\u0440\u043E\u0441\u0438\u0441\u0442\u0435\u043C\u044B");
/* 			HUD.log("Left Gear:  Hydraulic system Failed"); */
            kl = World.Rnd().nextFloat();
            kr = World.Rnd().nextFloat() * kl;
        } else
        if(s.startsWith("xgearr") || s.startsWith("GearR"))
        {
            if(super.FM.isPlayers())
            HUD.log("\u041F\u0440\u0430\u0432\u0430\u044F \u0441\u0442\u043E\u0439\u043A\u0430 \u0448\u0430\u0441\u0441\u0438: \u043E\u0442\u043A\u0430\u0437 \u0433\u0438\u0434\u0440\u043E\u0441\u0438\u0441\u0442\u0435\u043C\u044B");
/*             HUD.log("Right Gear:  Hydraulic system Failed"); */
            kr = World.Rnd().nextFloat();
            kl = World.Rnd().nextFloat() * kr;
        }
        {
            if(super.FM.isPlayers())
            HUD.log("\u0425\u0432\u043E\u0441\u0442\u043E\u0432\u043E\u0435 \u043A\u043E\u043B\u0435\u0441\u043E: \u043E\u0442\u043A\u0430\u0437 \u0433\u0438\u0434\u0440\u043E\u0441\u0438\u0441\u0442\u0435\u043C\u044B");
/*             HUD.log("Center Gear:  Hydraulic system Failed"); */
            kc = World.Rnd().nextFloat();
            kl = World.Rnd().nextFloat() * kc;
            kr = World.Rnd().nextFloat() * kc;
        }
        ((FlightModelMain) (super.FM)).CT.GearControl = 1.0F;
        ((FlightModelMain) (super.FM)).Gears.setHydroOperable(false);
    }

    public void rareAction(float paramFloat, boolean paramBoolean)
    {
        super.rareAction(paramFloat, paramBoolean);
        if(paramBoolean)
        {
			//Код перекидывания огня на соседний бак, вероятность 14%
            if(((FlightModelMain) (super.FM)).AS.astateTankStates[0] > 4 && World.Rnd().nextFloat() < 0.14F)
                ((FlightModelMain) (super.FM)).AS.hitTank(this, 2, 1);
            if(((FlightModelMain) (super.FM)).AS.astateTankStates[1] > 4 && World.Rnd().nextFloat() < 0.14F)
                ((FlightModelMain) (super.FM)).AS.hitTank(this, 2, 1);
            if(((FlightModelMain) (super.FM)).AS.astateTankStates[2] > 4 && World.Rnd().nextFloat() < 0.14F)
                ((FlightModelMain) (super.FM)).AS.hitTank(this, 0, 1);
            if(((FlightModelMain) (super.FM)).AS.astateTankStates[2] > 4 && World.Rnd().nextFloat() < 0.14F)
                ((FlightModelMain) (super.FM)).AS.hitTank(this, 1, 1);
			//Код протектора, вероятность прекращения течи 10%
            if(((FlightModelMain) (super.FM)).AS.astateTankStates[0] == 1 && World.Rnd().nextFloat() < 0.1F)
                ((FlightModelMain) (super.FM)).AS.repairTank(0);
            if(((FlightModelMain) (super.FM)).AS.astateTankStates[1] == 1 && World.Rnd().nextFloat() < 0.1F)
                ((FlightModelMain) (super.FM)).AS.repairTank(1);
            if(((FlightModelMain) (super.FM)).AS.astateTankStates[2] == 1 && World.Rnd().nextFloat() < 0.1F)
                ((FlightModelMain) (super.FM)).AS.repairTank(2);
            if(((FlightModelMain) (super.FM)).AS.astateTankStates[3] == 1 && World.Rnd().nextFloat() < 0.1F)
                ((FlightModelMain) (super.FM)).AS.repairTank(3);
			//Код затухания, вероятность затухания белого дыма 0.07%, после затухания остаётся течь
            if(((FlightModelMain) (super.FM)).AS.astateTankStates[0] == 2 && World.Rnd().nextFloat() < 0.007F)
				((FlightModelMain) (super.FM)).AS.setTankState(this, 0, ((FlightModelMain) (super.FM)).AS.astateTankStates[0] - 1);
            if(((FlightModelMain) (super.FM)).AS.astateTankStates[1] == 2 && World.Rnd().nextFloat() < 0.007F)
				((FlightModelMain) (super.FM)).AS.setTankState(this, 1, ((FlightModelMain) (super.FM)).AS.astateTankStates[1] - 1);
            if(((FlightModelMain) (super.FM)).AS.astateTankStates[2] == 2 && World.Rnd().nextFloat() < 0.007F)
				((FlightModelMain) (super.FM)).AS.setTankState(this, 2, ((FlightModelMain) (super.FM)).AS.astateTankStates[2] - 1);
            if(((FlightModelMain) (super.FM)).AS.astateTankStates[3] == 2 && World.Rnd().nextFloat() < 0.007F)
				((FlightModelMain) (super.FM)).AS.setTankState(this, 3, ((FlightModelMain) (super.FM)).AS.astateTankStates[3] - 1);
 			//Код затухания, вероятность затухания чёрного дыма 7%, после затухания остаётся белый дым
            if(((FlightModelMain) (super.FM)).AS.astateTankStates[0] == 3 && World.Rnd().nextFloat() < 0.07F)
				((FlightModelMain) (super.FM)).AS.setTankState(this, 0, ((FlightModelMain) (super.FM)).AS.astateTankStates[0] - 1);
            if(((FlightModelMain) (super.FM)).AS.astateTankStates[1] == 3 && World.Rnd().nextFloat() < 0.07F)
				((FlightModelMain) (super.FM)).AS.setTankState(this, 1, ((FlightModelMain) (super.FM)).AS.astateTankStates[1] - 1);
            if(((FlightModelMain) (super.FM)).AS.astateTankStates[2] == 3 && World.Rnd().nextFloat() < 0.07F)
				((FlightModelMain) (super.FM)).AS.setTankState(this, 2, ((FlightModelMain) (super.FM)).AS.astateTankStates[2] - 1);
            if(((FlightModelMain) (super.FM)).AS.astateTankStates[3] == 3 && World.Rnd().nextFloat() < 0.07F)
				((FlightModelMain) (super.FM)).AS.setTankState(this, 3, ((FlightModelMain) (super.FM)).AS.astateTankStates[3] - 1);
 			//Код затухания, вероятность затухания огня без дыма 5%, после затухания остаётся чёрный дым (чёрный дым может снова загореться, вероятность зашита где-то в базовых классах)
            if(((FlightModelMain) (super.FM)).AS.astateTankStates[0] == 4 && World.Rnd().nextFloat() < 0.05F)
				((FlightModelMain) (super.FM)).AS.setTankState(this, 0, ((FlightModelMain) (super.FM)).AS.astateTankStates[0] - 1);
            if(((FlightModelMain) (super.FM)).AS.astateTankStates[1] == 4 && World.Rnd().nextFloat() < 0.05F)
				((FlightModelMain) (super.FM)).AS.setTankState(this, 1, ((FlightModelMain) (super.FM)).AS.astateTankStates[1] - 1);
            if(((FlightModelMain) (super.FM)).AS.astateTankStates[2] == 4 && World.Rnd().nextFloat() < 0.05F)
				((FlightModelMain) (super.FM)).AS.setTankState(this, 2, ((FlightModelMain) (super.FM)).AS.astateTankStates[2] - 1);
            if(((FlightModelMain) (super.FM)).AS.astateTankStates[3] == 4 && World.Rnd().nextFloat() < 0.05F)
				((FlightModelMain) (super.FM)).AS.setTankState(this, 3, ((FlightModelMain) (super.FM)).AS.astateTankStates[3] - 1);
 			//Код затухания, вероятность затухания огня с дымом 0.85%, после затухания остаётся огонь без дыма (огонь без дыма может снова стать с дымом, вероятность зашита где-то в базовых классах)
            if(((FlightModelMain) (super.FM)).AS.astateTankStates[0] == 5 && World.Rnd().nextFloat() < 0.0085F)
				((FlightModelMain) (super.FM)).AS.setTankState(this, 0, ((FlightModelMain) (super.FM)).AS.astateTankStates[0] - 1);
            if(((FlightModelMain) (super.FM)).AS.astateTankStates[1] == 5 && World.Rnd().nextFloat() < 0.0085F)
				((FlightModelMain) (super.FM)).AS.setTankState(this, 1, ((FlightModelMain) (super.FM)).AS.astateTankStates[1] - 1);
            if(((FlightModelMain) (super.FM)).AS.astateTankStates[2] == 5 && World.Rnd().nextFloat() < 0.0085F)
				((FlightModelMain) (super.FM)).AS.setTankState(this, 2, ((FlightModelMain) (super.FM)).AS.astateTankStates[2] - 1);
            if(((FlightModelMain) (super.FM)).AS.astateTankStates[3] == 5 && World.Rnd().nextFloat() < 0.0085F)
				((FlightModelMain) (super.FM)).AS.setTankState(this, 3, ((FlightModelMain) (super.FM)).AS.astateTankStates[3] - 1);
        }
    }

    static Class _mthclass$(String s)
    {
        Class class1;
        try
        {
            class1 = Class.forName(s);
        }
        catch(ClassNotFoundException classnotfoundexception)
        {
            throw new NoClassDefFoundError(classnotfoundexception.getMessage());
        }
        return class1;
    }

    private static float kl = 1.0F;
    private static float kr = 1.0F;
    private static float kc = 1.0F;
    private float headPos[];
    private float headOr[];
    private static Orient tmpOrLH = new Orient();
    private float headYp;
    private float headTp;
    private float headYm;
    private float headTm;
    private float kangle;
    private float flapps;
    private boolean sideDoorOpened;
    private float oldctl;
    private float curctl;

    static 
    {
        Class class1 = com.maddox.il2.objects.air.LAGG_3RD.class;
        new NetAircraft.SPAWN(class1);
        Property.set(class1, "iconFar_shortClassName", "LaGG-3RD");
        Property.set(class1, "meshName", "3DO/Plane/LaGG-3RD(Multi1)/hier.him");
        Property.set(class1, "PaintScheme", new PaintSchemeFMPar05());
        Property.set(class1, "yearService", 1944F);
        Property.set(class1, "yearExpired", 1945.5F);
        Property.set(class1, "FlightModel", "FlightModels/LaGG-3RD.fmd:LAGG");
        Property.set(class1, "cockpitClass", new Class[] {
            com.maddox.il2.objects.air.CockpitLAGG_3_RD.class
        });
        Property.set(class1, "LOSElevation", 0.90695F);
        Aircraft.weaponTriggersRegister(class1, new int[] {
            1, 1
        });
        Aircraft.weaponHooksRegister(class1, new String[] {
            "_CANNON01", "_CANNON02"
        });
        Aircraft.weaponsRegister(class1, "default", new String[] {
            "MGunShVAKki 240", "MGunShVAKki 240"
        });
        Aircraft.weaponsRegister(class1, "none", new String[] {
            null, null
        });
    }
}